<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EntidadeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'nome'=>'required|max:100',
            'descricao'=>'nullable|max:255',
            'sobre'=>'nullable',
            'telefone'=>'required|numeric|min_digits:9|max_digits:9',
            'email'=>'nullable|email',
            'fundacao'=>'nullable|date',
        ];
    }

    public function messages()
    {
     
        return [
                'required'=>'Este campo é obrigatório.',
                'min'=>'Este campo deve ter pelo menos :min caracteres.',
                'max'=>'Este campo deve ter no máximo :max caracteres.',
                'min_digits'=>'Este campo deve ter pelo menos :min_digits digitos.',
                'max_digits'=>'Este campo deve ter no máximo :min_digits digitos.',
                'email'=>'Email inválido. Exemplo de um email válido: exemplo@gmail.com',
                'date'=>'O campo deve ser do tipo data. AAAA-MM-DD',
                'numeric'=>'Este campo deve ser numérico. Ex: 925111333.'
            ];
    }
}
